//
// automatically generated by spin2cpp v1.93 on Thu Oct 08 13:24:57 2015
// spin2cpp --ccode --main talk_demo2.spin 
//

/* 
┌─────────────────────────────────────────┬────────────────┬────────────────────────┬─────────────────┐
│ Vocal Tract v1.1                        │ by Chip Gracey │ (C)2006 Parallax, Inc. │ 28 October 2006 │
├─────────────────────────────────────────┴────────────────┴────────────────────────┴─────────────────┤
│                                                                                                     │
│ This object synthesizes a human vocal tract in real-time. It requires one cog and at least 80 MHz.  │
│                                                                                                     │
│ The vocal tract is controlled via 13 single-byte parameters which must reside in the parent object: │
│                                                                                                     │
│ VAR byte aa,ga,gp,vp,vr,f1,f2,f3,f4,na,nf,fa,ff    'vocal tract parameters                          │
│                                                                                                     │
│                                                                                                     │
│                  aa                                                                                 │
│            ┌────────────┐                                                                           │
│            │ ASPIRATION ├──┐                                                                       │
│            └────────────┘   │     f1       f2       f3       f4      na   nf                        │  
│                                ┌────┐   ┌────┐   ┌────┐   ┌────┐   ┌───────┐                       │
│                            +┣──┤ F1 ├──┤ F2 ├──┤ F3 ├──┤ F4 ├──┤ NASAL ├──┐                   │
│                 ga   gp        └────┘   └────┘   └────┘   └────┘   └───────┘   │                   │
│               ┌─────────┐   │                                                                      │
│               │ GLOTTAL ├──┘                                                  +┣── OUTPUT         │
│               └────┬────┘                                          fa   ff                         │ 
│                                                                ┌───────────┐   │                   │ 
│                 vp │ vr                                         │ FRICATION ├──┘                   │ 
│               ┌────┴────┐                                       └───────────┘                       │ 
│               │ VIBRATO │                                                                           │
│               └─────────┘                                                                           │
│                                                                                                     │
│                                                                                                     │
│ ┌───────────┬──────────────────────┬─────────────┬────────────────────────────────────────────────┐ │
│ │ parameter │ description          │ unit        │ notes                                          │ │
│ ├───────────┼──────────────────────┼─────────────┼────────────────────────────────────────────────┤ │
│ │    aa     │ aspiration amplitude │ 0..255      │ breath volume: silent..loud, linear            │ │
│ │    ga     │ glottal amplitude    │ 0..255      │ voice volume: silent..loud, linear             │ │
│ │    gp     │ glottal pitch        │ 1/48 octave │ voice pitch: 100 ─ 110.00Hz (musical note A2) │ │
│ │    vp     │ vibrato pitch        │ 1/48 octave │ voice vibrato pitch: 48 ─ ± 1/2 octave swing  │ │
│ │    vr     │ vibrato rate         │ 0.0763 Hz   │ voice vibrato rate: 52 ─ 4 Hz                 │ │
│ │    f1     │ formant1 frequency   │ 19.53 Hz    │ 1st resonator frequency: 40 ─ 781 Hz          │ │
│ │    f2     │ formant2 frequency   │ 19.53 Hz    │ 2nd resonator frequency: 56 ─ 1094 Hz         │ │
│ │    f3     │ formant3 frequency   │ 19.53 Hz    │ 3rd resonator frequency: 128 ─ 2500 Hz        │ │
│ │    f4     │ formant4 frequency   │ 19.53 Hz    │ 4th resonator frequency: 179 ─ 3496 Hz        │ │
│ │    na     │ nasal amplitude      │ 0..255      │ anti-resonator level: off..on, linear          │ │
│ │    nf     │ nasal frequency      │ 19.53 Hz    │ anti-resonator frequency: 102 ─ 1992 Hz       │ │
│ │    fa     │ frication amplitude  │ 0..255      │ white noise volume: silent..loud, linear       │ │
│ │    ff     │ frication frequency  │ 39.06 Hz    │ white noise frequency: 60 ─ 2344 Hz ("Sh")    │ │
│ └───────────┴──────────────────────┴─────────────┴────────────────────────────────────────────────┘ │
│                                                                                                     │
│ The parent object alternately modifies one or more of these parameters and then calls the go(time)  │
│ method to queue the entire 13-parameter frame for feeding to the vocal tract. The vocal tract will  │
│ load one queued frame after another and smoothly interpolate between them over specified amounts of │
│ time without interruption. Up to eight frames will be queued in order to relax the frame-generation │
│ timing requirement of the parent object. If eight frames are queued, the parent must then wait to   │
│ queue another frame. If the vocal tract runs out of frames, it will continue generating samples     │
│ based on the last frame. When a new frame is queued, it will immediately load it and begin inter-   │
│ polating towards it.                                                                                │
│                                                                                                     │
│ The vocal tract generates audio samples at a continuous rate of 20KHz. These samples can be output  │
│ to pins via delta-modulation for RC filtering or direct transducer driving. An FM aural subcarrier  │
│ can also be generated for inclusion into a TV broadcast controlled by another cog. Regardless of    │
│ any output mode, samples are always streamed into a special variable so that other objects can      │
│ access them in real-time.                                                                           │
│                                                                                                     │
│ In order to achieve optimal sound quality, it is worthwhile to maximize amplitudes such as 'ga' to  │
│ the point just shy of numerical overflow. Numerical overflow results in high-amplitude noise bursts │
│ which are quite disruptive. The closeness of 'f1'-'f4' and their relationship to 'gp' can greatly   │
│ influence the amount of 'ga' that can be applied before overflow occurs. You must determine through │
│ experimentation what the limits are. By pushing 'ga' close to the overflow point, you will maximize │
│ the signal-to-noise ratio of the vocal tract, resulting in the highest quality sound. Once your     │
│ vocal tract programming is complete, the attenuation level can then be used to reduce the overall   │
│ output in 3dB steps while preserving the signal-to-noise ratio.                                     │
│                                                                                                     │
├─────────────────────────────────────────────────────────────────────────────────────────────────────┤
│ Revision History                                                      v1.0 released 26 October 2006 │
│                                                                                                     │
│ v1.1  If the vocal tract runs out of frames, its internal parameters will now be brought all the    │
│       way to the last frame's values. Before, they were left one interpolation point shy, and then  │
│       set to the last frame's values at the start of the next frame. For continuous frames this was │
│       trivial, but it posed a problem during frame gaps because the internal parameters would get   │
│       stalled at transition points just shy of the last frame's values. This change makes the vocal │
│       tract behave more sensibly during frame gaps.                                                 │                                     
│                                                                                                     │
└─────────────────────────────────────────────────────────────────────────────────────────────────────┘

 */

#include <propeller.h>
#include "text2speech.h"

#ifdef __GNUC__
#define INLINE__ static inline
#define Yield__() __asm__ volatile( "" ::: "memory" )
#define PostEffect__(X, Y) __extension__({ int32_t tmp__ = (X); (X) = (Y); tmp__; })
#else
#define INLINE__ static
static int32_t tmp__;
#define PostEffect__(X, Y) (tmp__ = (X), (X) = (Y), tmp__)
#define Yield__()
#define waitcnt(n) _waitcnt(n)
#define coginit(id, code, par) _coginit((unsigned)(par)>>2, (unsigned)(code)>>2, id)
#define cognew(code, par) coginit(0x8, (code), (par))
#define cogstop(i) _cogstop(i)
#endif

INLINE__ int32_t Min__(int32_t a, int32_t b) { return a < b ? a : b; }
INLINE__ int32_t Max__(int32_t a, int32_t b) { return a > b ? a : b; }
INLINE__ int32_t Shr__(uint32_t a, uint32_t b) { return (a>>b); }

static uint8_t dat[] = {
  0x00, 0x1a, 0xfe, 0xa0, 0x0a, 0x01, 0xbc, 0x80, 0x00, 0x18, 0xfe, 0xe4, 0x1e, 0x48, 0xfe, 0xa0, 
  0xd4, 0x9a, 0xbe, 0xa0, 0x0b, 0x09, 0xbc, 0x80, 0x01, 0x48, 0x7e, 0x61, 0x02, 0x08, 0xf0, 0x84, 
  0x04, 0x48, 0xfe, 0xe4, 0xc6, 0xd6, 0xbe, 0xa0, 0x0d, 0x48, 0xfe, 0xa0, 0x08, 0x4a, 0xfe, 0xa0, 
  0xe9, 0xd8, 0xbe, 0xa0, 0x0b, 0x19, 0xbc, 0x80, 0x0c, 0x4a, 0xfe, 0xe4, 0x08, 0x18, 0xfc, 0x84, 
  0x01, 0xd6, 0xfd, 0x80, 0x01, 0xda, 0xfd, 0x80, 0x01, 0xe0, 0xfd, 0x80, 0x0b, 0x48, 0xfe, 0xe4, 
  0xc6, 0xa6, 0xbf, 0xa0, 0xf0, 0x49, 0xbe, 0xa0, 0x08, 0x48, 0xfe, 0x80, 0x04, 0x4a, 0xfe, 0xa0, 
  0x24, 0xed, 0xbf, 0x08, 0x04, 0x48, 0xfe, 0x80, 0x0a, 0x31, 0xbc, 0x80, 0x18, 0x4a, 0xfe, 0xe4, 
  0x24, 0x1b, 0xbe, 0x08, 0x04, 0x48, 0xfe, 0x80, 0x24, 0x1d, 0xbe, 0x08, 0xf1, 0x1f, 0xbe, 0xa0, 
  0x0e, 0x1f, 0xbe, 0x80, 0x0e, 0x1f, 0xbe, 0xf8, 0xf0, 0x49, 0xbe, 0x08, 0x24, 0x45, 0xbe, 0x38, 
  0x22, 0x49, 0xbe, 0xa0, 0x0a, 0x48, 0xfe, 0x38, 0x0d, 0x49, 0xbe, 0x80, 0x24, 0xf5, 0xbf, 0xa0, 
  0x22, 0x49, 0xbe, 0xa0, 0x00, 0x49, 0xbe, 0x80, 0x24, 0xf7, 0xbf, 0xa0, 0xf0, 0x49, 0xbe, 0xa0, 
  0x04, 0x48, 0xfe, 0x80, 0x24, 0x45, 0x3e, 0x08, 0xf3, 0xe4, 0x3d, 0x61, 0x01, 0xe4, 0xfd, 0x34, 
  0xf3, 0xe4, 0x3d, 0x61, 0x01, 0xe4, 0xfd, 0x34, 0xf3, 0xe4, 0x3d, 0x61, 0x01, 0xe4, 0xfd, 0x34, 
  0x26, 0x49, 0xbe, 0xa0, 0xf2, 0x4a, 0xbe, 0xa0, 0xd0, 0xd6, 0xfe, 0x5c, 0x08, 0x48, 0xfe, 0x38, 
  0x24, 0x45, 0xbe, 0xa0, 0x2a, 0x49, 0xbe, 0xa0, 0x0a, 0x48, 0xfe, 0x28, 0x24, 0x2b, 0xbe, 0x80, 
  0x29, 0x49, 0xbe, 0xa0, 0x15, 0x4b, 0xbe, 0xa0, 0xc7, 0xd6, 0xfe, 0x5c, 0x28, 0x49, 0xbe, 0x80, 
  0x02, 0x48, 0xfe, 0x28, 0x24, 0x4b, 0xbe, 0xa0, 0x02, 0x4a, 0xfe, 0x28, 0x25, 0x49, 0xbe, 0x80, 
  0x24, 0x4b, 0xbe, 0xa0, 0x04, 0x4a, 0xfe, 0x28, 0x25, 0x49, 0xbe, 0x80, 0x24, 0x4b, 0xbe, 0xa0, 
  0x08, 0x4a, 0xfe, 0x28, 0x25, 0x49, 0xbe, 0x80, 0xf1, 0x48, 0xbe, 0x80, 0xbe, 0x8c, 0xfd, 0x5c, 
  0x25, 0x2d, 0xbe, 0x80, 0x16, 0x49, 0xbe, 0xa0, 0xbe, 0x8c, 0xfd, 0x5c, 0x01, 0x4b, 0xbe, 0x84, 
  0x27, 0x49, 0xbe, 0xa0, 0xc7, 0xd6, 0xfe, 0x5c, 0x06, 0x48, 0xfe, 0x38, 0x24, 0x45, 0xbe, 0x80, 
  0x00, 0x46, 0xfe, 0xa0, 0x2b, 0x43, 0xbe, 0xa0, 0x18, 0x45, 0xbe, 0x80, 0x19, 0x47, 0xbe, 0x80, 
  0xd6, 0xa6, 0xff, 0x5c, 0x22, 0x31, 0xbe, 0xa0, 0x23, 0x33, 0xbe, 0xa0, 0x2c, 0x43, 0xbe, 0xa0, 
  0x1a, 0x45, 0xbe, 0x80, 0x1b, 0x47, 0xbe, 0x80, 0xd6, 0xa6, 0xff, 0x5c, 0x22, 0x35, 0xbe, 0xa0, 
  0x23, 0x37, 0xbe, 0xa0, 0x2d, 0x43, 0xbe, 0xa0, 0x1c, 0x45, 0xbe, 0x80, 0x1d, 0x47, 0xbe, 0x80, 
  0xd6, 0xa6, 0xff, 0x5c, 0x22, 0x39, 0xbe, 0xa0, 0x23, 0x3b, 0xbe, 0xa0, 0x2e, 0x43, 0xbe, 0xa0, 
  0x1e, 0x45, 0xbe, 0x80, 0x1f, 0x47, 0xbe, 0x80, 0xd6, 0xa6, 0xff, 0x5c, 0x22, 0x3d, 0xbe, 0xa0, 
  0x23, 0x3f, 0xbe, 0xa0, 0x22, 0x41, 0xbe, 0x80, 0x30, 0x43, 0xbe, 0xa0, 0xd6, 0xa6, 0xff, 0x5c, 
  0x2f, 0x49, 0xbe, 0xa0, 0x22, 0x4b, 0xbe, 0xa0, 0xd0, 0xd6, 0xfe, 0x5c, 0x20, 0x45, 0xbe, 0xa0, 
  0x24, 0x41, 0xbe, 0xa4, 0xf2, 0x48, 0xbe, 0xa0, 0x03, 0x48, 0xfe, 0x38, 0x24, 0x2f, 0xbe, 0x80, 
  0x01, 0x48, 0xfe, 0x38, 0x24, 0x2f, 0xbe, 0x80, 0x32, 0x49, 0xbe, 0xa0, 0x01, 0x48, 0xfe, 0x28, 
  0x24, 0x2f, 0xbe, 0x80, 0x31, 0x49, 0xbe, 0xa0, 0x17, 0x4b, 0xbe, 0xa0, 0xc7, 0xd6, 0xfe, 0x5c, 
  0x24, 0x45, 0xbe, 0x80, 0x82, 0x00, 0x3c, 0x5c, 0x83, 0x00, 0x00, 0x00, 0x21, 0x04, 0xfd, 0x5c, 
  0xf0, 0x23, 0xbe, 0xa0, 0x20, 0x22, 0xfe, 0x80, 0x10, 0x23, 0xbe, 0x80, 0x11, 0x27, 0xbe, 0x08, 
  0x03, 0x27, 0xbe, 0x62, 0x91, 0x00, 0x54, 0x5c, 0xbc, 0x1a, 0xbd, 0xa0, 0x0d, 0x24, 0xfe, 0xa0, 
  0x21, 0x04, 0xfd, 0x5c, 0x33, 0x4d, 0xbe, 0xa0, 0x0b, 0x1b, 0xbd, 0x80, 0x8c, 0x24, 0xfe, 0xe4, 
  0x83, 0x00, 0x7c, 0x5c, 0x01, 0x26, 0xfe, 0x80, 0x13, 0x29, 0xbe, 0xa0, 0x33, 0x39, 0xfd, 0x50, 
  0x26, 0x3b, 0xfd, 0x54, 0x33, 0x3d, 0xfd, 0x54, 0x40, 0x4d, 0xfd, 0x54, 0x03, 0x22, 0xfe, 0x80, 
  0x0d, 0x24, 0xfe, 0xa0, 0x21, 0x04, 0xfd, 0x5c, 0x11, 0x49, 0xbe, 0x00, 0x18, 0x48, 0xfe, 0x2c, 
  0x33, 0x4b, 0xbe, 0xa0, 0x25, 0x4d, 0xbe, 0xa0, 0x24, 0x67, 0xbe, 0xa0, 0x25, 0x49, 0xbe, 0x85, 
  0x24, 0x49, 0xbe, 0xb0, 0x01, 0xfe, 0x7f, 0x36, 0x08, 0x4a, 0xfe, 0xa0, 0x01, 0x48, 0xfe, 0x2d, 
  0x13, 0x49, 0xb2, 0x80, 0xa3, 0x4a, 0xfe, 0xe4, 0x24, 0x81, 0xbe, 0xbc, 0x01, 0x38, 0xfd, 0x80, 
  0x0a, 0x3b, 0xbd, 0x80, 0x0a, 0x3d, 0xbd, 0x80, 0x0a, 0x4d, 0xbd, 0x80, 0x01, 0x22, 0xfe, 0x80, 
  0x99, 0x24, 0xfe, 0xe4, 0x21, 0x04, 0xfd, 0x5c, 0xbd, 0x62, 0xbd, 0xa0, 0x0d, 0x24, 0xfe, 0xa0, 
  0x21, 0x04, 0xfd, 0x5c, 0x40, 0x4d, 0xbe, 0x80, 0x0b, 0x63, 0xbd, 0x80, 0xb0, 0x24, 0xfe, 0xe4, 
  0x13, 0x29, 0xbe, 0x80, 0x02, 0x29, 0x3e, 0x61, 0xad, 0x00, 0x4c, 0x5c, 0x10, 0x22, 0xfe, 0x84, 
  0x11, 0xff, 0x3f, 0x08, 0x10, 0x20, 0xfe, 0x80, 0x7f, 0x20, 0xfe, 0x60, 0x83, 0x00, 0x7c, 0x5c, 
  0x33, 0x4d, 0xbe, 0xa0, 0x40, 0x4d, 0xbe, 0x80, 0x24, 0x4b, 0xbe, 0xa0, 0x10, 0x4a, 0xfe, 0x28, 
  0x1c, 0x48, 0xfe, 0x28, 0x08, 0x4b, 0xbe, 0x60, 0x05, 0x4b, 0xbe, 0x68, 0x25, 0x4b, 0xbe, 0x04, 
  0x04, 0x4b, 0xbe, 0x68, 0x24, 0x4b, 0xbe, 0x2c, 0x00, 0x00, 0x7c, 0x5c, 0x13, 0x4a, 0xfe, 0x28, 
  0x07, 0x4b, 0x3e, 0x62, 0x09, 0x4b, 0x3e, 0x61, 0x25, 0x4b, 0xbe, 0xb0, 0x06, 0x4b, 0xbe, 0x68, 
  0x01, 0x4a, 0xfe, 0x2c, 0x25, 0x4b, 0xbe, 0x04, 0x25, 0x4b, 0xbe, 0xbc, 0x0f, 0x4a, 0xfe, 0x2c, 
  0x11, 0x48, 0xfe, 0x28, 0x0f, 0x4a, 0xfe, 0x38, 0x0e, 0x4a, 0xfe, 0x2c, 0x4d, 0x01, 0x7c, 0x5c, 
  0x01, 0x48, 0xfe, 0x39, 0x25, 0x49, 0xb2, 0x80, 0x01, 0x44, 0xfe, 0x38, 0x22, 0x49, 0xbe, 0xa0, 
  0x03, 0x48, 0xfe, 0x38, 0x24, 0x45, 0xbe, 0x80, 0x22, 0x49, 0xbe, 0xa0, 0x04, 0x48, 0xfe, 0x38, 
  0x24, 0x45, 0xbe, 0x80, 0x01, 0x46, 0xfe, 0x38, 0x23, 0x49, 0xbe, 0xa0, 0x03, 0x48, 0xfe, 0x38, 
  0x24, 0x47, 0xbe, 0x80, 0x23, 0x49, 0xbe, 0xa0, 0x04, 0x48, 0xfe, 0x38, 0x24, 0x47, 0xbe, 0x80, 
  0x22, 0x49, 0xbe, 0xa0, 0x23, 0x45, 0xbe, 0x84, 0x24, 0x47, 0xbe, 0x80, 0x00, 0x43, 0xbe, 0x85, 
  0x6d, 0x01, 0x7c, 0x5c, 0x21, 0x43, 0xbe, 0xa1, 0x23, 0x49, 0xbe, 0xa0, 0x01, 0x48, 0xfe, 0x38, 
  0x22, 0x4b, 0xbe, 0xa0, 0x01, 0x4a, 0xfe, 0x38, 0x24, 0x45, 0xbe, 0x94, 0x25, 0x47, 0xbe, 0x90, 
  0xf4, 0x42, 0xbe, 0x94, 0x00, 0x00, 0x92, 0x66, 0x01, 0x00, 0x00, 0x00, 0x00, 0x10, 0x06, 0x80, 
  0x76, 0x14, 0x90, 0x4b, 0x6d, 0xe1, 0xec, 0x27, 0x50, 0x47, 0x44, 0x14, 0x0c, 0x35, 0x2c, 0x0a, 
  0x85, 0x5f, 0x17, 0x05, 0x79, 0xd8, 0x8b, 0x02, 0x54, 0xf1, 0x45, 0x01, 0x4d, 0xf9, 0xa2, 0x00, 
  0xbb, 0x7c, 0x51, 0x00, 0x60, 0xbe, 0x28, 0x00, 0x30, 0x5f, 0x14, 0x00, 0x98, 0x2f, 0x0a, 0x00, 
  0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x01, 0xff, 0xff, 0xff, 0x00, 
  0x00, 0x00, 0x01, 0x00, 0x00, 0xd0, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 
  0xfe, 0x0f, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 
  0xe3, 0x00, 0x00, 0x00, 
};
int32_t VocalTract_start(VocalTract *self, int32_t tract_ptr, int32_t pos_pin, int32_t neg_pin, int32_t fm_offset)
{
  // Start vocal tract driver - starts a cog
  // returns false if no cog available
  //
  //   tract_ptr = pointer to vocal tract parameters (13 bytes)
  //     pos_pin = positive delta-modulation pin (-1 to disable)
  //     neg_pin = negative delta-modulation pin (pos_pin must also be enabled, -1 to disable)
  //   fm_offset = offset frequency for fm aural subcarrier generation (-1 to disable, 4_500_000 for NTSC)
  // Reset driver
  VocalTract_stop(self);
  // Remember vocal tract parameters pointer
  self->tract = tract_ptr;
  // Initialize pace to 100%
  self->pace = 100;
  
  // Remove first pin cannot be -1 caviat.
  if( (pos_pin < 0) && (neg_pin > -1) ) 
  {
    pos_pin = neg_pin;
    neg_pin = -1;
  } 
  if( pos_pin == neg_pin)
  {
    neg_pin = -1;
  }      
     
  // If delta-modulation pin(s) enabled, ready output(s) and ready ctrb for duty mode
  if (pos_pin > (-1)) {
    (&self->dira_)[((Shr__(pos_pin, 5)) & 0x1)] = (&self->dira_)[((Shr__(pos_pin, 5)) & 0x1)] | ((1<<pos_pin));
    self->ctrb_ = 402653184 + (pos_pin & 0x3f);
    if (neg_pin > (-1)) {
      (&self->dira_)[((Shr__(neg_pin, 5)) & 0x1)] = (&self->dira_)[((Shr__(neg_pin, 5)) & 0x1)] | ((1<<neg_pin));
      self->ctrb_ = self->ctrb_ + (67108864 + ((neg_pin & 0x3f) << 9));
    }
  }
  // If fm offset is valid, ready ctra for pll mode with divide-by-16 (else disabled)
  if (fm_offset > (-1)) {
    self->ctra_ = 92274688;
  }
  // Ready frqa value for fm offset
  {
    int32_t _idx__0001;
    for(_idx__0001 = 0; _idx__0001 < 33; _idx__0001++) {
      self->frqa_ = self->frqa_ << 1;
      if (fm_offset >= CLKFREQ) {
        fm_offset = fm_offset - CLKFREQ;
        (self->frqa_++);
      }
      fm_offset = fm_offset << 1;
    }
  }
  // Ready 20KHz sample period
  self->cnt_ = CLKFREQ / 20000;
  // Launch vocal tract cog
  return (self->cog = cognew((int32_t)(&(*(int32_t *)&dat[0])), (int32_t)(&self->attenuation)) + 1);
}

int32_t VocalTract_stop(VocalTract *self)
{
  // Stop vocal tract driver - frees a cog
  // If already running, stop vocal tract cog
  if (self->cog) {
    cogstop((PostEffect__(self->cog, 0) - 1));
  }
  memset( (void *)&self->index, 0, sizeof(int32_t)*0x29);
  return 0;
}

int32_t VocalTract_set_attenuation(VocalTract *self, int32_t level)
{
  // Set master attenuation level (0..7, initially 0)
  self->attenuation = level;
  return 0;
}

int32_t VocalTract_set_pace(VocalTract *self, int32_t percentage)
{
  // Set pace to some percentage (initially 100)
  self->pace = percentage;
  return 0;
}

int32_t VocalTract_go(VocalTract *self, int32_t time)
{
  // Queue current parameters to transition over time
  //
  //   actual time = integer(time * 100 / pace) #> 2 * 700µs (at least 1400µs, see set_pace)
  // Wait until frame available (first long will be zeroed)
  while (self->frames[self->index]) {
    Yield__();
  }
  // Load parameters into frame
  memcpy( (void *)(void *)(((int32_t)(&self->frames[self->index]) + 3)), (void *)self->tract, 1*(13));
  // Write stepsize into frame (non-0 alerts vocal tract that frame is ready)
  self->frames[self->index] = self->frames[self->index] | (16777216 / (Max__(((time * 100) / self->pace), 2)));
  self->index = (self->index + frame_longs) & 0x1f;
  return 0;
}

int32_t VocalTract_full(VocalTract *self)
{
  // Returns true if the parameter queue is full
  // (useful for checking if "go" would have to wait) 
  return self->frames[self->index];
}

int32_t VocalTract_empty(VocalTract *self)
{
  int32_t	i;
  int32_t status = 0;
  // Returns true if the parameter queue is empty
  // (useful for detecting when the vocal tract is finished)
  for(i = 0; i <= 0x7; i++) {
    if (self->frames[(i * frame_longs)]) {
      /* false */
      return status;
    }
  }
  return -1;
}

int32_t VocalTract_sample_ptr(VocalTract *self)
{
  // Returns the address of the long which receives the audio samples in real-time
  // (signed 32-bit values updated at 20KHz)
  return (int32_t)(&self->sample);
}

int32_t VocalTract_aural_id(VocalTract *self)
{
  // Returns the id of the cog executing the vocal tract algorithm
  // (for connecting a broadcast tv driver with the aural subcarrier)
  return (self->cog - 1);
}

